<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * 
 * This model contains all db functions related to product management
 * @author Teamtweaks
 *
 */
class Product_model extends My_Model
{
	
	public function add_product($dataArr=''){
			$this->db->insert(PRODUCT,$dataArr);
	}
	
	public function add_subproduct_insert($dataArr=''){
			$this->db->insert(SUBPRODUCT,$dataArr);
	}
	
	public function contact_seller_add($dataArr=''){
			$this->db->insert(CONTACTSELLER,$dataArr);
	}

	public function contact_user_add($dataArr=''){
			$this->db->insert(CONTACTUSER,$dataArr);
	}

	public function edit_product($dataArr='',$condition=''){
			$this->db->where($condition);
			$this->db->update(PRODUCT,$dataArr);
	}
	
	public function edit_subproduct_update($dataArr='',$condition=''){
			$this->db->where($condition);
			$this->db->update(SUBPRODUCT,$dataArr);
	}
	
	public function view_product($condition=''){
			return $this->db->get_where(PRODUCT,$condition);
			
	}
	
	
	public function view_product_details($condition = ''){
		$select_qry = "select p.*,u.id as sellerid,u.email as selleremail,u.full_name,u.user_name,u.thumbnail,u.feature_product from ".PRODUCT." p 
		LEFT JOIN ".USERS." u on (u.id=p.user_id) ".$condition;
		$productList = $this->ExecuteQuery($select_qry);
		return $productList;
			
	}
		
	public function get_product_details()
	{
	
	$select_qrys = "select p.*,pf.* from ".PRODUCT." p 
		LEFT JOIN ".PRODUCT_FEEDBACK." pf on (pf.seller_product_id=p.id) ";
		$productfeedbackList = $this->ExecuteQuery($select_qrys);
		return $productfeedbackList;
	
	}
	
	public function get_featured_details($pid='0'){
		$Query = "select p.*,u.full_name,u.user_name,u.thumbnail,u.feature_product from ".PRODUCT." p LEFT JOIN ".USERS." u on u.id=p.user_id where p.seller_product_id=".$pid." and p.status='Publish'";
		$productList = $this->ExecuteQuery($Query);
		$productList->mode = 'sell_product';
		if ($productList->num_rows() != 1){
			$Query = "select p.*,u.full_name,u.user_name,u.thumbnail,u.feature_product from ".USER_PRODUCTS." p LEFT JOIN ".USERS." u on u.id=p.user_id where p.seller_product_id=".$pid." and p.status='Publish'";
			$productList = $this->ExecuteQuery($Query);
			$productList->mode = 'user_product';
		} 
		return $productList;
	}
	
	public function get_wants_product($wantList){
		$productList = '';
		if ($wantList->num_rows() == 1){
			$productIds = array_filter(explode(',', $wantList->row()->product_id));
			$this->db->where_in('p.seller_product_id',$productIds);
			$this->db->where('p.status','Publish');
			$this->db->select('p.*,u.full_name,u.user_name,u.thumbnail,u.feature_product');
			$this->db->from(PRODUCT.' as p');
			$this->db->join(USERS.' as u','u.id=p.user_id');
			$productList = $this->db->get();
		} 
		return $productList;
	}
	
	public function get_notsell_wants_product($wantList){
		$productList = '';
		if ($wantList->num_rows() == 1){
			$productIds = array_filter(explode(',', $wantList->row()->product_id));
			$this->db->where_in('p.seller_product_id',$productIds);
			$this->db->where('p.status','Publish');
			$this->db->select('p.*,u.full_name,u.user_name,u.thumbnail,u.feature_product');
			$this->db->from(USER_PRODUCTS.' as p');
			$this->db->join(USERS.' as u','u.id=p.user_id');
			$productList = $this->db->get();
		} 
		return $productList;
	}
	
	public function view_notsell_product_details($condition = ''){
 		$select_qry = "select p.*,u.full_name,u.user_name,u.thumbnail,u.feature_product from ".USER_PRODUCTS." p LEFT JOIN ".USERS." u on u.id=p.user_id ".$condition;
		$productList = $this->ExecuteQuery($select_qry);
		return $productList;
			
	}
	
	
	public function view_atrribute_details(){
		$select_qry = "select * from ".ATTRIBUTE." where status='Active'";
		return $attList = $this->ExecuteQuery($select_qry);
	
	}
	
	public function view_cat_details($id){

		
		$this->db->select('*');
		$this->db->from(CATEGORY);
		 if($id != '') { 
		$this->db->where('id',$id);	
		}
		$query = $this->db->get();
		//echo $this->db->last_query(); 
		return $countall = $query->result_array(); 
		
		//$query->result_array($attList);
	
	}
	
	
	public function view_subproduct_details($prdId=''){
		$select_qry = "select * from ".SUBPRODUCT." where product_id = '".$prdId."'";
		return $attList = $this->ExecuteQuery($select_qry);
	
	}
	
	public function view_subproduct_details_join($prdId=''){
		$select_qry = "select a.* from ".SUBPRODUCT." a join ".PRODUCT_ATTRIBUTE." b on a.attr_id = b.id where a.product_id = '".$prdId."'";
		return $attList = $this->ExecuteQuery($select_qry);
	
	}
	
	public function view_subproduct_details_group($prdId=''){
		$select_qry = "select a.attr_id,b.attr_name from ".SUBPRODUCT." a join ".PRODUCT_ATTRIBUTE." b on a.attr_id = b.id where a.product_id = '".$prdId."' GROUP BY a.attr_id ";
		return $attList = $this->ExecuteQuery($select_qry);
	
	}
	
	public function view_shopping_cart_subproduct_val($userid='',$prdId=''){
		$select_qry = "select quantity,attribute_values from ".SHOPPING_CART." where product_id = '".$prdId."' and user_id='".$userid."'";
		return $shopAttrList = $this->ExecuteQuery($select_qry);
	
	}
	
	public function view_product_atrribute_details(){
		$select_qry = "select * from ".PRODUCT_ATTRIBUTE." where status='Active'";
		return $attList = $this->ExecuteQuery($select_qry);
	
	}
	
	public function view_category_details(){
	
		$select_qry = "select * from ".CATEGORY." where rootID=0";
		$categoryList = $this->ExecuteQuery($select_qry);
		$catView='';$Admpriv = 0;$SubPrivi = '';

		foreach ($categoryList->result() as $CatRow){
			
			$catView .= $this->view_category_list($CatRow,'1');		
			
			$sel_qry = "select * from ".CATEGORY." where rootID='".$CatRow->id."'  ";	
			$SubList = $this->ExecuteQuery($sel_qry);	
				
			foreach ($SubList->result() as $SubCatRow){
					
				$catView .= $this->view_category_list($SubCatRow,'2');	
					
				$sel_qry1 = "select * from ".CATEGORY." where rootID='".$SubCatRow->id."'  ";	
				$SubList1 = $this->ExecuteQuery($sel_qry1);	
					
				foreach ($SubList1->result() as $SubCatRow1){
					$catView .= $this->view_category_list($SubCatRow1,'3');	
					
					$sel_qry2 = "select * from ".CATEGORY." where rootID='".$SubCatRow1->id."'  ";	
					$SubList2 = $this->ExecuteQuery($sel_qry2);	
		
					foreach ($SubList2->result() as $SubCatRow2){
						$catView .= $this->view_category_list($SubCatRow2,'4');	

					}			
				}
			}
		}
					
		return $catView;
	}
	
	public function view_category_list($CatRow,$val){
	$SubcatView ='';
	$SubcatView .= '<span class="cat'.$val.'"><input name="category_id[]" class="checkbox" type="checkbox" value="'.$CatRow->id.'" tabindex="7"><strong>'.$CatRow->cat_name.' &nbsp;</strong></span>';
	return $SubcatView;					
	}

	public function get_category_details($catList=''){
		$catListArr = explode(',', $catList);
		$select_qry = "select * from ".CATEGORY." where rootID=0";
		$categoryList = $this->ExecuteQuery($select_qry);
		$catView='';$Admpriv = 0;$SubPrivi = '';

		foreach ($categoryList->result() as $CatRow){
			
			$catView .= $this->get_category_list($CatRow,'1',$catListArr);		
			
			$sel_qry = "select * from ".CATEGORY." where rootID='".$CatRow->id."'  ";	
			$SubList = $this->ExecuteQuery($sel_qry);	
				
			foreach ($SubList->result() as $SubCatRow){
					
				$catView .= $this->get_category_list($SubCatRow,'2',$catListArr);	
					
				$sel_qry1 = "select * from ".CATEGORY." where rootID='".$SubCatRow->id."'  ";	
				$SubList1 = $this->ExecuteQuery($sel_qry1);	
					
				foreach ($SubList1->result() as $SubCatRow1){
					$catView .= $this->get_category_list($SubCatRow1,'3',$catListArr);	
					
					$sel_qry2 = "select * from ".CATEGORY." where rootID='".$SubCatRow1->id."'  ";	
					$SubList2 = $this->ExecuteQuery($sel_qry2);	
		
					foreach ($SubList2->result() as $SubCatRow2){
						$catView .= $this->get_category_list($SubCatRow2,'4',$catListArr);	

					}			
				}
			}
		}
		return $catView;
	}
	
	public function get_category_list($CatRow,$val,$catListArr=''){
	$SubcatView ='';
	if (in_array($CatRow->id, $catListArr)){ 
		$checkStr = 'checked="checked"';
	}else {
		$checkStr = '';
	}
	$SubcatView .= '<span class="cat'.$val.'"><input name="category_id[]" '.$checkStr.' class="checkbox" type="checkbox" value="'.$CatRow->id.'" tabindex="7"><strong>'.$CatRow->cat_name.' &nbsp;</strong></span>';
	return $SubcatView;					
	}

	public function get_cat_list($ids=''){
		$this->db->where_in('id',explode(',', $ids));
		return $this->db->get(CATEGORY);
	}

	public function get_top_users_in_category($cat=''){
		$productArr = array();
		$userArr = array();
		$userCountArr = array();
		$condition = " where p.category_id like '".$cat.",%' AND p.status = 'Publish' OR p.category_id like '%,".$cat."' AND p.status = 'Publish' OR p.category_id like '%,".$cat.",%' AND p.status = 'Publish' OR p.category_id='".$cat."' AND p.status = 'Publish'";
		$productDetails = $this->view_product_details($condition);
		if ($productDetails->num_rows()>0){
			foreach ($productDetails->result() as $productRow){
				if (!in_array($productRow->id, $productArr)){
					array_push($productArr, $productRow->id);
					if ($productRow->user_id != ''){
						if (!in_array($productRow->user_id, $userArr)){
							array_push($userArr, $productRow->user_id);
							$userCountArr[$productRow->user_id] = 1;
						}else {
							$userCountArr[$productRow->user_id]++;
						}
					}
				}
			}
		}
		arsort($userCountArr);
		return $userCountArr;
	}
	
	public function get_recent_like_users($pid='',$limit='10',$sort='desc'){
		$Query = 'select pl.*, p.product_name, p.likes, u.full_name, u.user_name,u.thumbnail from '.PRODUCT_LIKES.' pl 
					JOIN '.PRODUCT.' p on p.seller_product_id=pl.product_id 
					JOIN '.USERS.' u on u.id=pl.user_id and u.status="Active"
					where pl.product_id="'.$pid.'" order by pl.id '.$sort.' limit '.$limit;
		return $this->ExecuteQuery($Query);
	}
	
	public function get_recent_user_likes($uid='',$pid='',$limit='3',$sort='desc'){
		$condition = '';
		if ($pid!=''){
			$condition = ' and pl.product_id != "'.$pid.'" ';
		}
		$Query = 'select pl.*,u.user_name,u.full_name,u.thumbnail,p.product_name,p.id as PID,p.created,p.sale_price,p.image from '.PRODUCT_LIKES.' pl
					JOIN '.USERS.' u on u.id=pl.user_id 
					JOIN '.PRODUCT.' p on p.seller_product_id=pl.product_id
					JOIN '.USERS.' u1 on u1.id=p.user_id and u1.group="Seller" and u1.status="Active"
					where pl.user_id = "'.$uid.'" '.$condition.' order by pl.id '.$sort.' limit '.$limit;
		return $this->ExecuteQuery($Query);
	}
	
	public function get_like_user_full_details($pid='0'){
		$Query = "select u.* from ".PRODUCT_LIKES.' p
					JOIN '.USERS.' u on u.id=p.user_id
					where p.product_id='.$pid;
		return $this->ExecuteQuery($Query);
	}
	
	public function getCategoryValues($selVal,$whereCond) {	
		$sel = 'select '.$selVal.' from '.CATEGORY.' c LEFT JOIN '.CATEGORY.' sbc ON c.id = sbc.rootID '.$whereCond.' ';
		return $this->ExecuteQuery($sel);
	}
	
	public function getCategoryResults($selVal,$whereCond) {	
		$sel = 'select '.$selVal.' from '.CATEGORY.' '.$whereCond.' ';
		return $this->ExecuteQuery($sel);
	}
	
	public function searchShopyByCategory($whereCond) {	
 		$sel = 'select p.* from '.PRODUCT.' p 
		 		LEFT JOIN '.USERS.' u on u.id=p.user_id 
		 		'.$whereCond.' ';
		return $this->ExecuteQuery($sel);
	}
	/*
	echo $sel = 'select p.*,s.* from '.PRODUCT.' p,'.SELLER.' a
		 		LEFT JOIN '.USERS.' u on u.id=p.user_id 
				LEFT JOIN '.SELLER.' s on s.id=p.user_id 
		 		'.$whereCond.' ';die;
	*/
	
	public function searchShopyByCategoryUSERS($whereCond) {	
 		$sel = 'select p.*,u.user_name from '.USER_PRODUCTS.' p 
		 		LEFT JOIN '.USERS.' u on u.id=p.user_id 
		 		'.$whereCond.' ';
		return $this->ExecuteQuery($sel);
	}
	
	public function searchSizeBy($whereCond) {	
 		$sel = 'select p.* from '.PRODUCT.' p LEFT JOIN '.SUBPRODUCT.' S on p.id=S.product_id JOIN '.PRODUCT_ATTRIBUTE.' PA on S.attr_id=PA.id
		 		LEFT JOIN '.USERS.' u on u.id=p.user_id 
		 		'.$whereCond.' ';
		return $this->ExecuteQuery($sel);
	}
	
	public function searchSizeByUser($whereCond) {	
 		$sel = 'select p.*,u.user_name from '.USER_PRODUCTS.' p 
		 		LEFT JOIN '.USERS.' u on u.id=p.user_id 
		 		'.$whereCond.' ';
		return $this->ExecuteQuery($sel);
	}
	
	public function add_user_product($uid=''){
		$seller_product_id = mktime();
		$checkId = $this->check_product_id($seller_product_id);
		while ($checkId->num_rows()>0){
			$seller_product_id = mktime();
			$checkId = $this->check_product_id($seller_product_id);
		}
		$dataArr = array(
			'product_name'		=>	$this->input->post('name'),
			'seourl'			=>	url_title($this->input->post('name'),'-'),
			'sale_price'		=>	$this->input->post('price') + $this->input->post('shipprice'),
			'price'				=>	$this->input->post('price'),
			'product_shipping'	=>	$this->input->post('shipprice'),
			'product_attribute'	=>	$this->input->post('size'),
			'quantity'			=>	$this->input->post('userqty'),			
			'category_id'		=>	$this->input->post('category'),
			'excerpt'			=>	$this->input->post('note'),
			'image'				=>	$this->input->post('image'),
			'user_id'			=>	$uid,
			'seller_product_id' => $seller_product_id
		);
		$this->simple_insert(USER_PRODUCTS,$dataArr);
		return $seller_product_id;
	}
	public function product_like_list($search_productname='')
	{
		$Query = "select * from ".PRODUCT." where product_name like '%".$search_productname."%'"; 

		return $this->ExecuteQuery($Query);
	}
	
	public function check_product_id($pid=''){
		$checkId = $this->get_all_details(USER_PRODUCTS,array('seller_product_id'=>$pid));
		if ($checkId->num_rows()==0){
			$checkId = $this->get_all_details(PRODUCT,array('seller_product_id'=>$pid));
		}
		return $checkId;
	}
	
	public function get_products_by_category($categoryid='',$sort='desc'){
		$Query = "select p.*,u.user_name,u.full_name,u.thumbnail from ".PRODUCT." p
			LEFT JOIN ".USERS." u on u.id=p.user_id
			where p.status='Publish' and FIND_IN_SET('".$categoryid."',p.category_id) order by p.`created` ".$sort;
		return $this->ExecuteQuery($Query);
	}
	
	public function view_product_comments_details($condition = ''){
		$select_qry = "select p.product_name,c.product_id,u.full_name,u.user_name,u.thumbnail,c.comments ,u.email,c.id,c.status,c.user_id as CUID
		from ".PRODUCT_COMMENTS." c 
		LEFT JOIN ".USERS." u on u.id=c.user_id 
		LEFT JOIN ".PRODUCT." p on p.seller_product_id=c.product_id ".$condition;
		$productComment = $this->ExecuteQuery($select_qry);
		return $productComment;
			
	}
	public function Update_Product_Comment_Count($product_id){
	
		$Query = "UPDATE ".PRODUCT." SET comment_count=(comment_count + 1) WHERE seller_product_id='".$product_id."'";
		$this->ExecuteQuery($Query);
	}
	public function Update_Product_Comment_Count_Reduce($product_id){
	
		$Query = "UPDATE ".PRODUCT." SET comment_count=(comment_count - 1) WHERE seller_product_id='".$product_id."'";
		return $this->ExecuteQuery($Query);
	}
	public function get_products_search_results($search_key='',$limit='5'){
		$Query = 'select p.* from '.PRODUCT.' p 
				LEFT JOIN '.USERS.' u on u.id=p.user_id
				where p.product_name like "%'.$search_key.'%" and p.status="Publish" and p.quantity>0 and u.status="Active" and u.group="Seller"
				or p.product_name like "%'.$search_key.'%" and p.status="Publish" and p.quantity>0 and p.user_id=0
				limit '.$limit;
		return $this->ExecuteQuery($Query);
	}
	
	public function get_products_search_results_user($search_key='',$limit='5'){
		$Query = 'select p.*,u.user_name from '.USER_PRODUCTS.' p 
				LEFT JOIN '.USERS.' u on u.id=p.user_id
				where p.product_name like "%'.$search_key.'%" and p.status="Publish" and p.quantity>0 and u.status="Active" limit '.$limit;
		return $this->ExecuteQuery($Query);
	}

	
	public function get_user_search_results($search_key='',$limit='5'){
		$Query = 'select * from '.USERS.' where full_name like "%'.$search_key.'%" and status="Active" OR user_name like "%'.$search_key.'%" and status="Active" limit '.$limit;
		return $this->ExecuteQuery($Query);
	}
	
	public function get_product_full_details($pid='0'){
		$Query = "select p.*,u.full_name,u.user_name,u.thumbnail,u.feature_product,u.email,u.email_notifications,u.notifications from ".PRODUCT." p JOIN ".USERS." u on u.id=p.user_id where p.seller_product_id='".$pid."'";
		$productDetails = $this->ExecuteQuery($Query);
		if ($productDetails->num_rows() == 0){
			$Query = "select p.*,u.full_name,u.user_name,u.thumbnail,u.feature_product,u.email,u.email_notifications,u.notifications from ".USER_PRODUCTS." p JOIN ".USERS." u on u.id=p.user_id where p.seller_product_id='".$pid."'";
			$productDetails = $this->ExecuteQuery($Query);
			$productDetails->prodmode = 'user';
		}else {
			$productDetails->prodmode = 'seller';
		}
		return $productDetails;
	}
	
	public function get_user_created_lists($pid='0'){
		$Query = "select * from ".LISTS_DETAILS." where FIND_IN_SET('".$pid."',product_id)";
		return $this->ExecuteQuery($Query);
	}
	
	
	 /**
    * 
    * Merge two arrays and sort the result array using array_multisort
    * @param Array $ar1	
    * @param Array $ar2
    * @param String $field	=> Field name for sort
    * @param String $type	=> Sort type asc or desc
    */
	/*******************************Should return the Object values**************************/
   /*public function get_sorted_array_object($ar1=array(),$ar2=array(),$field='id',$type='asc'){
   		$products_list_arr = array();
		if (count($ar1)>0 && $ar1->num_rows()>0){
			foreach ($ar1->result() as $ar1_row){
				$products_list_arr['product'][] = $ar1_row;
    			$products_list_arr[$field][] = $ar1_row->$field;
			}
		}

		if (count($ar2)>0 && $ar2->num_rows()>0){
			foreach ($ar2->result() as $ar2_row){
				$products_list_arr['product'][] = $ar2_row;
    			$products_list_arr[$field][] = $ar2_row->$field;
			}
		}
		
		if ($type == 'asc'){
			$sort = SORT_ASC;
		}else {
			$sort = SORT_DESC;
		}
		
		array_multisort($products_list_arr[$field],$sort,
    		$products_list_arr['product']
    	);
		
		return $products_list_arr['product'];
   }
	*/
	
	public function get_sorted_array_object($ar1=array(),$ar2=array(),$field='id',$type='asc'){

   		$products_list_arr = array();
		if (count($ar1)>0 && $ar1->num_rows()>0){
			foreach ($ar1->result() as $ar1_row){
				$products_list_arr['product'][] = $ar1_row;
    			$products_list_arr[$field][] = $ar1_row->$field;
			}
		}

		if (count($ar2)>0 && $ar2->num_rows()>0){
			foreach ($ar2->result() as $ar2_row){
				$products_list_arr['product'][] = $ar2_row;
    			$products_list_arr[$field][] = $ar2_row->$field;
			}
		}
		
		if ($type == 'asc'){
			$sort = SORT_ASC;
		}else {
			$sort = SORT_DESC;
		}
		
		array_multisort($products_list_arr[$field],$sort,
    		$products_list_arr['product']
    	);
		
		return $products_list_arr['product'];
   }
	
	
	//S Codes
	// Select product data for product table
   public function get_productdetail_data($productseourl){
   		$this->db->select('*');
		$this->db->from(PRODUCT);
		$this->db->where('seourl',$productseourl);
		$referQuery = $this->db->get();
		
		
	//	echo $this->db->last_query(); die;
		return $referResult = $referQuery->result_array();
		
   }
   
   
      public function get_storedetail_data($columns,$cat_id,$searchPerPage,$paginationNo){
// echo 'gsg'; die;
   		$this->db->select($columns);
		$this->db->from(PRODUCT);
		$this->db->where('user_id','42');
		if($cat_id != ''){
		$where = "FIND_IN_SET('".$cat_id."', category_id)";  
         $this->db->where($where);
		}
		$referQuery = $this->db->get();
		//echo $this->db->last_query(); die;
		return $referResult = $referQuery->result_array();
		
   }
	
	//seller shop view
	    public function get_storedetail_data_store($columns,$cat_id,$searchPerPage,$paginationNo,$seller_id){
  
   		$this->db->select($columns);
		$this->db->from(PRODUCT);
		$this->db->where('user_id',$seller_id);
		if($cat_id != '0'){
		$where = "FIND_IN_SET('".$cat_id."', category_id)";  
         $this->db->where($where);
		}
		$referQuery = $this->db->get();
		//echo $this->db->last_query(); die;
		return $referResult = $referQuery->result_array();
		
   }
   
   	//seller shop view featured
	    public function get_storedetail_data_storefeature($columns,$cat_id,$searchPerPage,$paginationNo,$seller_id,$limit){
  
   		$this->db->select($columns);
		$this->db->from(PRODUCT);
		$this->db->where('user_id',$seller_id);
		$this->db->where('product_featured','Yes');
		if($cat_id != '0'){
		$where = "FIND_IN_SET('".$cat_id."', category_id)";  
         $this->db->where($where);
		}
		$this->db->limit($limit);
		$referQuery = $this->db->get();
		//echo $this->db->last_query(); die;
		return $referResult = $referQuery->result_array();
		
   }
   
   
   
   	//Category Detail view
	    public function get_categorydetail_view($columns,$cat_id,$searchPerPage,$paginationNo){
 
   		$this->db->select($columns);
		$this->db->from(PRODUCT);
		
		if($cat_id != '0'){
		$where = "FIND_IN_SET('".$cat_id."', category_id)";  
         $this->db->where($where);
		}
		$referQuery = $this->db->get();
		//echo $this->db->last_query(); die;
		return $referResult = $referQuery->result_array();
		
   }
   
   
	
	
	//s Codes ends
	
	
	/*******************************Should return the array values**************************/
	 public function get_sorted_array($ar1=array(),$ar2=array(),$field='id',$type='asc'){
   		$products_list_arr = array();
		if (count($ar1)>0 && $ar1->num_rows()>0){
			foreach ($ar1->result_array() as $ar1_row){
				$products_list_arr['product'][] = $ar1_row;
    			$products_list_arr[$field][] = $ar1_row[$field];
			}
		}

		if (count($ar2)>0 && $ar2->num_rows()>0){
			foreach ($ar2->result_array() as $ar2_row){
				$products_list_arr['product'][] = $ar2_row;
    			$products_list_arr[$field][] = $ar2_row[$field];
			}
		}
		
		if ($type == 'asc'){
			$sort = SORT_ASC;
		}else {
			$sort = SORT_DESC;
		}
		
		array_multisort($products_list_arr[$field],$sort,
    		$products_list_arr['product']
    	);
		
		return $products_list_arr['product'];
   }
		///////// Get Feature Shop Products for Home Page //////////////
		
/*		public function getFeatureProduct($userId=''){
			$this->db->select(SELLER.'.*,'.PRODUCT.'.*');
			$this->db->from(SELLER);
			$this->db->join(PRODUCT, PRODUCT.'.user_id ='.SELLER.'.seller_id');
			$this->db->where(PRODUCT.'.user_id !=','0');
			$this->db->where(SELLER.'.status','active');
			$this->db->order_by(PRODUCT.'.id', 'RANDOM');
			$this->db->limit(5);
			$query = $this->db->get();
			$resultContent = $query->result_array();
			//echo $this->db->last_query(); die;
			return $resultContent;
		}
		*/
		public function getSellerDetails(){
			   $this->db->select(SELLER.'.*');
               $this->db->from(SELLER);
			   $this->db->where(SELLER.'.status','active');
		       $this->db->order_by(SELLER.'.id', 'RANDOM');
			   $this->db->limit(5);
			  $query = $this->db->get();
		       $resultContent = $query->result_array();
			//echo $this->db->last_query(); die;
			   return $resultContent;

		}
		
		public function getFeatureProduct($userId=''){
			   $this->db->select(PRODUCT.'.*');
               $this->db->from(PRODUCT);
			   $this->db->where(PRODUCT.'.status','Publish');
			   $this->db->where(PRODUCT.'.user_id ',$userId);
			   $this->db->where(PRODUCT.'.product_featured ','Yes');
		       $this->db->order_by(PRODUCT.'.id', 'RANDOM');
			   $this->db->limit(4);
			   $query = $this->db->get();
		       $resultContent = $query->result_array();
			//echo $this->db->last_query(); die;
			   return $resultContent;

		}
		
    function getBlogDetails($type = '')
    {	
   		$this->db->select(POSTS.'.*,'.USER.'.user_name,email,group,thumbnail,city,country,about_us');
		$this->db->from(POSTS);
		$this->db->join(USER, USER.'.id ='.POSTS.'.posted_user_id');
		$this->db->where(POSTS.'.post_status !=','draft');
		$this->db->where(POSTS.'.post_status ','active');
		if($type == 'admin'){
		      $this->db->where(POSTS.'.posted_user_id ','0');
		}else{
			 $this->db->where(POSTS.'.posted_user_id !=','0');
		}
		$this->db->order_by(POSTS.".posted_date", "desc"); 
		$this->db->limit(3);
		$query = $this->db->get();
		$resultContent = $query->result_array();
		return $resultContent;
    }
	function getFavoriteDetails($shopid)
    {
   		$this->db->select(FAVORITE.'.id');
		$this->db->from(FAVORITE);
		$this->db->where('shop_id', $shopid);
		$this->db->where('user_id', $this->session->userdata('shopsy_session_user_id'));
		$query = $this->db->get();
		$resultContent = $query->result_array();
		//echo $this->db->last_query();
		//print_r($resultContent);
		// die;
		return $resultContent;
			
	}  
	function getUserFavoriteDetails($shopid)
    {
   		$this->db->select(FAVORITE.'.*');
		$this->db->from(FAVORITE);
		$this->db->where('user_id', $this->session->userdata('shopsy_session_user_id'));
		$query = $this->db->get();
		$resultContent = $query->result_array();
		return $resultContent;
	}  
	function getUserFavoriteProduct($shopid)
    {
   		$this->db->select(PRODUCT.'.*');
		$this->db->from(PRODUCT);
		$this->db->join(SELLER, SELLER.'.id ='.POSTS.'.posted_user_id');
		$this->db->where('user_id', $shopid);
		$query = $this->db->get();
		$resultContent = $query->result_array();
		return $resultContent;
	}  

	function getSellerProductDetails($shopid)
    {
   		$this->db->select(SELLER.'.*');
		$this->db->from(SELLER);
		$this->db->where('id',$shopid);
		$query = $this->db->get();
		$resultContent = $query->result_array();
		return $resultContent;
	}  

	function getProductFavDetails($userid)
    {
   		$this->db->select(PRODUCT.'.*');
		$this->db->from(PRODUCT);
		$this->db->where('user_id',$userid);
		$this->db->where('product_featured','Yes');
		$this->db->limit(4);
		$query = $this->db->get();
		$resultContent = $query->result_array();
		return $resultContent;
	}  

}

?>